package coreservlets;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet, ktry oblicza czsto da wyraon jako
 *  liczba da otrzymywanych w cigu jednej sekundy.
 *  Wynik oblicze jest nastpnie przekazywany do strony JSP,
 *  ktra je wywietla.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ProcessRequestStats extends HttpServlet {

  protected void doGet(HttpServletRequest request, 
                       HttpServletResponse response) 
        throws ServletException, IOException {
    // Odczytanie requestRecords
    ServletContext context = this.getServletContext();
    ArrayList<Long> requestRecords = 
      (ArrayList<Long>) context.getAttribute("requestRecords");
    long firstMillis = requestRecords.get(0);
    int totalRequests = requestRecords.size();
    long lastMillis = requestRecords.get(totalRequests - 1);
    // Obliczenie cznej liczby sekund
    long totalSeconds = (lastMillis - firstMillis) / 1000;
    // Obliczenie liczby da na sekund
    double ratio = totalRequests / (double) totalSeconds;
    ratio = ((int)(ratio * 100) / (double) 100);

    // Wypenienie komponentu RequestStats; zapisanie
    // komponentu w zasigu dania i przekazanie
    // go do strony prezentacji statystyk.
    RequestStatsBean requestStats = 
      new RequestStatsBean(totalSeconds, totalRequests, ratio);
    request.setAttribute("stats", requestStats);
    RequestDispatcher dispatcher = 
      request.getRequestDispatcher("/WEB-INF/pages/req-stats.jsp");
    dispatcher.forward(request, response);
  }
}
